/**
 * @file    ExternalDependencyUtil.cs
 * 
 * @author  jschoi
 * @date    2024~
 * @copyright Copyright © Com2uS Platform Corporation. All Right Reserved.
 * @defgroup Hive.Unity.Editor
 * @{
 * @brief HIVE External Dependency Util <br/><br/>
 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using System;
using System.IO;
using System.ComponentModel;
using System.Reflection;
using System.Xml;

namespace Hive.Unity.Editor
{    
    public class ExternalDependencyUtil
    {
        // Enum의 선언된 description 데이터 반환
        public static string getEnumDescription(Enum value) {
            Type type = value.GetType();
            string name = Enum.GetName(type, value);
            if (name == null)
            {
                return null;
            }
            else
            {
                FieldInfo field = type.GetField(name);
                if (field == null)
                    return name;
                else
                {
                    DescriptionAttribute attr = Attribute.GetCustomAttribute(field, typeof(DescriptionAttribute)) as DescriptionAttribute;
                    if (attr == null)
                        return name;
                    else
                        return attr.Description;
                }
            }
        }

        // HiveSDK Unity 샘플빌드 여부 확인
        public static bool isSampleBuild() {
            if(File.Exists(ExternalDependencyConst.sampleFilePath))
                return true;
            else
                return false;
        }

        // 파일 유뮤 확인 후 삭제
        public static void deleteFile(string path) {
            if(File.Exists(path)) {
                File.Delete(path);
            }
        }

        // 디렉토리 경로 복사
        public static void directoryCopy(string sourcePath, string destPath) {
            DirectoryInfo dir = new DirectoryInfo(sourcePath);

            if (!dir.Exists)
            {
                throw new DirectoryNotFoundException(
                    "Source directory does not exist or could not be found: "
                    + dir
                );
            }

            FileInfo[] files = dir.GetFiles();
            foreach (FileInfo file in files)
            {
                if (file.Name.Contains(".meta"))
                    continue;
                string tempPath = Path.Combine(destPath, file.Name);
                file.CopyTo(tempPath, true);
            }
        }

        // 폴더가 아닌 파일이지 판단
        public static bool isFile(string path, string file) {
            string[] files = Directory.GetFiles(path, file);
            return files.Length > 0 ? true : false;
        }
    }
}
